
package w83b.xml;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.XMLReader;

import w83b.w83bUtilidadesComunes.W83bErrorCodes;
import w83b.w83bUtilidadesComunes.W83bException;
import w83b.xml.exception.W83bXmlException;



/**
 * Validacin de una fuente xml contra un esquema xsd
 */
public class W83bXmlSchemaValidation implements java.io.Serializable{//NOPMD

	private static final long serialVersionUID = 1L;
	/**
     * Permite validar una fuente xml contra un esquema.
     * 
     * @param xsdPathname
     *            Ruta de acceso y nombre del fichero con el esquema
     * @param xmlDocument
     *            Ruta de acceso y nombre del fichero con la fuente xml
     * @throws W83bException
     *             Si el chequeo no es satisfactorio.
     */
	public static void validationXMLSchema(String xsdPathname, String xmlDocument)
			throws W83bException, W83bXmlException {
    	
        if (log.isLoggable(Level.INFO))
        {
        	log.info("validationXMLSchema(...)");
        }
        
        W83bXmlValidator validator = new W83bXmlValidator ();
        validator.create(false);
        
        validator.setSchemaURL(xsdPathname);
        boolean isValid = validator.checkXmlStringText(xmlDocument);
        if (!isValid) {
        	
            if (log.isLoggable(Level.INFO)) {
            	log.info("isValid?:: " + isValid);
            	log.info(validator.getCheckInfo());
            }
        	throw new W83bException("w83b", W83bErrorCodes.EC_EVALUATION_XML_ERROR);
        }
    }
	
	final public static XMLReader makeXMLReader() { 
	    try {
            final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(false);
            final SAXParser saxParser = saxParserFactory.newSAXParser();
            final XMLReader parser = saxParser.getXMLReader();
            
            return parser;
        } catch (Exception e) {
        }
        
        return null;
	}	
    
	private static Logger log =	Logger.getLogger(W83bXmlSchemaValidation.class.getName());//NOPMD

}
